/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.conwip;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableMap;
import cz.insophy.inplan.planning.mokos.conwip.ConwipIslandLog;
import cz.insophy.inplan.planning.mokos.conwip.GorWrapper;
import cz.insophy.inplan.shop.CapabilityIsland;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConwipLog {
    private static final Logger log = LoggerFactory.getLogger(ConwipLog.class);
    private final long fixationTime;
    private final ImmutableMap<CapabilityIsland, ConwipIslandLog> islandLogs;

    protected ConwipLog(long fixationTime, Map<CapabilityIsland, AtomicLong> normtimeAvailable) {
        this.fixationTime = fixationTime;
        ImmutableMap.Builder<CapabilityIsland, ConwipIslandLog> islLogBob = ImmutableMap.builder();
        for (Map.Entry<CapabilityIsland, AtomicLong> entry : normtimeAvailable.entrySet()) {
            islLogBob.put(entry.getKey(), new ConwipIslandLog(entry.getKey().getName(), entry.getValue().get()));
        }
        this.islandLogs = islLogBob.build();
    }

    public void logAllocation(@Nonnull GorWrapper gorw, long t) {
        for (GorWrapper.GarWrapper gaw : gorw.getGarWrappers()) {
            this.islandLogs.get(gaw.getIsland()).logAllocation(gaw, t);
        }
    }

    public void logDeallocation(@Nonnull GorWrapper.GarWrapper gaw, long t) {
        this.islandLogs.get(gaw.getIsland()).logDeallocation(gaw, t);
    }

    public Collection<ConwipIslandLog> getIslands() {
        return this.islandLogs.values();
    }

    public long getFixationTime() {
        return this.fixationTime;
    }

    public void write() {
        try {
            File f = File.createTempFile("conwip", ".json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.writeValue(f, (Object)this);
            log.info("Wrote conwip progress log to {}", (Object)f);
        }
        catch (Exception e) {
            log.warn("Cannot write conwip progress log. {}", (Object)e.getMessage());
        }
    }

    public void logBlock(CapabilityIsland island) {
        this.islandLogs.get(island).logBlock();
    }
}

